procedure $see_ar
argument local string scalar runno
argument local namelist freqs
argument local string scalar db_path
block

   if missing(location(@open.db,"LOUT"))
      open <ac re> file(local'db_path+"/lfpr_run"+runno+".db") as lout
      -local'loutopened = TRUE
   else
      -local'loutopened = FALSE
   end if

   device graphics postl
   page margins horizontal 0, vertical 0

   legend size xsmall, fill horizontal, color black, font F10
   legend division row 1, column auto
   legend content symbol on
   tick label size xsmall, font F10
   label bottom text "Age", size small

   map color postscript C7 "B0B0B0", C8 "D9D9D9"

   batch #1 scolor C13, bstyle solid, shading paint, color C1, draw bar
   batch #2 scolor C14, bstyle solid, shading paint, color C1, draw bar
   batch #3 color c4, draw line, style solid, thickness medium
   batch #4 color c2, draw line, style solid, thickness medium

   case 1 to 64
   local'agesmstr = string(lout'agesm)
   image case axis "<series:local'agesmstr>"

   page divi rows 1, columns 1

   loop for sfreq in freqs
      open <ac over; kind graphic> file("run"+local'runno+"ar_"+name(sfreq)+".ps") as ar.ps
      channel graphics ar.ps
      channel reports ar.ps

      graph
         if (min(lout'rhom&sfreq) lt 0) or (min(lout'rhof&sfreq) lt 0)  
            tick left numeric linear (-1 to 1.0001 step .1), zero on
         else
            tick left numeric linear (0 to 1.0001 step .1), zero on
         end if
         title #1 size med, text "AR Parameters"
         data lout'rhom&sfreq <batch name "Men">, &&
              lout'rhof&sfreq <batch name "Women">, &&
              lout'rhom&sfreq <batch name "Men">, &&
              lout'rhof&sfreq <batch name "Women">
         draw line (@bottom.axis.min,.5) to (@bottom.axis.max,.5)
         draw line (@bottom.axis.min,-.5) to (@bottom.axis.max,-.5)
         depict grid on, axis left
         draw marking at 0
      end graph

      close ar.ps
      execute "!(ps2pdf run"+local'runno+"ar_"+name(sfreq)+".ps; "+&&
                "gv run"+local'runno+"ar_"+name(sfreq)+".ps; "+&&
                "rm -f run"+local'runno+"ar_"+name(sfreq)+".ps)&"
   end loop

   if local'loutopened
      close lout
   end if

end block
end procedure
